/*
 * Automat.c
 *
 * Created: 05.11.2012 11:39:51
 *  Author: p324431
 */ 

#include "Automaton.h"

AutomatStates_t State;
/**
This function init the state machine.
*/
void StateMachineInit(void)
{
	State= Init;
}

/**
This function updated the state machine.
*/
void StateMachineUpdate(void)
{
	switch (State)
	{
		case Init:
			{
				Actuators.z_axis_to_z_plus = 0;
				Actuators.z_axis_to_z_minus = 0;
				Actuators.x_axis_to_x_plus = 0;
				Actuators.x_axis_to_x_minus = 1;
				Actuators.y_axis_to_y_plus = 0;
				Actuators.y_axis_to_y_minus = 0;
				
				if (Sensors.x_axis_at_position_x_minus)
					State = DriveRight;
				
				break;
			}
			
		case DriveRight:
			{
				Actuators.x_axis_to_x_plus = 1;
				Actuators.x_axis_to_x_minus = 0;
				Actuators.y_axis_to_y_plus = 0;
				Actuators.y_axis_to_y_minus = 0;
				Actuators.z_axis_to_z_plus = 0;
				Actuators.z_axis_to_z_minus = 0;
				
				if (Sensors.x_axis_at_position_x_plus)
					State = DriveDown;
				
				break;
			}
			
		case DriveDown:
			{
				Actuators.x_axis_to_x_plus = 0;
				Actuators.x_axis_to_x_minus = 0;
				Actuators.y_axis_to_y_plus = 1;
				Actuators.y_axis_to_y_minus = 0;
				Actuators.z_axis_to_z_plus = 0;
				Actuators.z_axis_to_z_minus = 0;
				
				if (Sensors.y_axis_at_position_y_plus)
					State = DriveLeft;
				
				break;
			}
			
		case DriveLeft:
			{
				Actuators.x_axis_to_x_plus = 0;
				Actuators.x_axis_to_x_minus = 1;
				Actuators.y_axis_to_y_plus = 0;
				Actuators.y_axis_to_y_minus = 0;
				Actuators.z_axis_to_z_plus = 0;
				Actuators.z_axis_to_z_minus = 0;
				
				if (Sensors.x_axis_at_position_x_minus)
					State = DriveUp;
				break;
			}
			
		case DriveUp:
			{
				Actuators.x_axis_to_x_plus = 0;
				Actuators.x_axis_to_x_minus = 0;
				Actuators.y_axis_to_y_plus = 0;
				Actuators.y_axis_to_y_minus = 1;
				Actuators.z_axis_to_z_plus = 0;
				Actuators.z_axis_to_z_minus = 0;
				
				if (Sensors.y_axis_at_position_y_minus)
					State = DriveRight;
				break;
			}
	}
	

}